#include "SetSyncModeCommand.h"
#include "../DataTypes/DataString.h"
namespace SimulationEngine
{

SetSyncModeCommand::SetSyncModeCommand():ICommand(ConfigurationServer::GetInstance()->GetCommandSetSyncModeKey())
{
}

SetSyncModeCommand::~SetSyncModeCommand()
{
}

list<DataParameter*> SetSyncModeCommand::execute(list <DataParameter *> pars)
{
	DataBool *databool = (DataBool *)(pars.front());
	list <DataParameter *> ret;
	if (databool->GetValue() && SimulationEngineController::GetInstance()->GetAutoAdjustMode())
	{
		ret.push_back(new DataString("Sync Mode has been successfully setted, setting Auto-Adjust mode OFF"));
		SimulationEngineController::GetInstance()->SetAutoAdjustMode(false);
	}
	else
	{
		ret.push_back(new DataString("Sync Mode has been successfully setted"));
	}
	
	SimulationEngineController::GetInstance()->SetSyncMode(databool->GetValue());
	
	
	
	return ret;
}

}
